//Started scripting on 27/04/15.
if (!global.ShadowMamba)
global.ShadowMamba = new Object();
var sm = global.ShadowMamba;

function sm_after_perform(p) {
var unit = p.source_unit;
var target = p.target_unit;
var tile = p.target_tile;
var skill = p.skill;
var flags = skill.ScriptFlags;
var success = p.success;
if (success) {
if (flags.get("summon_random")) {
sm_summonRandom(p);
}
if (flags.get("create_items")) {
sm_createItems(p);
}
if (flags.get("apply_effects")) {
if (flags.get("summon_random")) return;
sm_applyEffects(p);
}
if (flags.get("remove_effects")) {
sm_removeEffects(p);
}
if (flags.get("aditional_description")) {
var descriptor = flags.get("aditional_description");
if (!(target.FriendlyType.indexOf(descriptor) > -1)) {
// indexOf looks through a string and returns the index (or position) of the sought for string, or -1 if it's not there
// so if the indexOf isn't -1 here, we know that unit's FriendlyType contains the word we're looking for and should handle it somehow
target.FriendlyType = descriptor + " " + target.FriendlyType;
shared.ShareUnitUpdate(target);
}
}
if (flags.get("remove_aditional_description")) {
var description = flags.get("remove_aditional_description");
var descriptor = description.split(",");
for (var i = 0; i < descriptor.length; i++) {
target.FriendlyType = (target.FriendlyType).replace(descriptor[i], "");
target.FriendlyType = (target.FriendlyType).trim();
shared.ShareUnitUpdate(target);
}
}
if (flags.get("steal_item")) {
sm_stealItem(p);
}
if (flags.get("random_damage")) {
sm_randomDamage(p);
}
if (flags.get("drain_point")) {
sm_drainPoint(p);
}
if (flags.get("switch_places")) {
if (!target) {
say("Cannot switch places with nothing!");
return;
}
shared.Map.MoveUnit(target, unit.Tile.X, unit.Tile.Y);
shared.Map.MoveUnit(unit, tile.X, tile.Y);
}
}
}

function sm_after_use(u) {
var unit = u.source_unit;
var target = u.target_unit;
var tile = u.target_tile;
var item = u.item;
var flags = item.ScriptFlags;
var success = u.success;
if (!success && flags.get("create_item_on_failed_use")) {
if (flags.get("create_items")) {
sm_createItemOnFail(u);
}
else say("Error: the create items flag is necessary in order to create an item.")
}
if (success) {
if (flags.get("summon_random")) {
sm_summonRandom(u);
}
if (flags.get("create_items")) {
sm_createItems(u);
}
if (flags.get("apply_effects")) {
if(flags.get("summon_random")) return;
sm_applyEffects(u);
}
if (flags.get("remove_effects")) {
sm_removeEffects(u);
}
if (flags.get("aditional_description")) {
var descriptor = flags.get("aditional_description");
if (!(target.FriendlyType.indexOf(descriptor) > -1)) {
// indexOf looks through a string and returns the index (or position) of the sought for string, or -1 if it's not there
// so if the indexOf isn't -1 here, we know that unit's FriendlyType contains the word we're looking for and should handle it somehow
target.FriendlyType = descriptor + " " + target.FriendlyType;
shared.ShareUnitUpdate(target);
}
}
if (flags.get("remove_aditional_description")) {
var description = flags.get("remove_aditional_description");
var descriptor = description.split(",");
for (var i = 0; i < descriptor.length; i++) {
target.FriendlyType = (target.FriendlyType).replace(descriptor[i], "");
target.FriendlyType = (target.FriendlyType).trim();
shared.ShareUnitUpdate(target);
}
}
if (flags.get("random_damage")) {
sm_randomDamage(u);
}
if (flags.get("drain_point")) {
sm_drainPoint(u);
}
if (flags.get("switch_places")) {
if (!target) {
say("Cannot switch places with nothing!");
return;
}
shared.Map.MoveUnit(target. source.Tile.X, source.Tile.Y);
shared.Map.MoveUnit(source, tile.X, tile.Y);
}
}
}

function sm_after_movement(a) {
var unit = a.unit;
 var added = a.unitAdded;
var origin = a.origin;
var flags = unit.ScriptFlags;
if (flags.get("effects_after_movement")) {
if (added) return;
var newEffects = flags.get("effects_after_movement");
var effects = newEffects.split(",");
for (var i = 0; i < effects.length; i++) {
shared.ApplyEffect(effects[i], unit, unit.Tile);
}
}
/*
if (flags.get("splash_effects_after_movement")) {
var splashEffects = flags.get("effects_after_movement");
splashEffects = splashEffects.split(",");
for (var i = 0; i < splashEffects.length; i++) {


}
*/

}


// The following are copied from Craig Brett's scripts, until I can figure out how to do my own. Credit goes to him.

function semiString(original) {
if (original.indexOf(";") == -1)
return original;
var choices = original.split(';');
var randomIndex = Math.round(Math.random() * (choices.length - 1));
var pick = choices[randomIndex];
return pick;
}

function slashString(original) {
if (original.indexOf("/") == -1)
return original;
var choices = original.split('/');
var randomIndex = Math.round(Math.random() * (choices.length - 1));
var pick = choices[randomIndex];
return pick;
}

    function chooseFromARandomSelectString(original, separator, forbidden) {
        if (!separator || separator == "")
            separator = "|";
        if (original.indexOf(separator) == -1)
            return original;
        var choices = original.split(separator);
        // if we've passed in some forbidden choices, remove them from the choices
        if (forbidden && choices) {
            for (var index = choices.length - 1; index >= 0; index--) {
                var choice = choices[index];
                // indexOf should work to tell us if the forbidden array contains this choice
                if (forbidden.indexOf(choice) > -1) {
                    // splice can be used on an array in this way to remove elements
                    choices.splice(index, 1);
                }
            }
        }
        var randomIndex = Math.round(Math.random() * (choices.length - 1));
        var pick = choices[randomIndex];
        return pick;
    }

/*
function chooseFromARandomSelectString(original) {
if (original.indexOf("|") == -1)
return original;
var choices = original.split('|');
var randomIndex = Math.round(Math.random() * (choices.length - 1));
var pick = choices[randomIndex];
return pick;
}
*/

// a version of String.Format found on StackOverflow
// First, checks if it isn't implemented yet.
/*

if (!String.prototype.format) {
  String.prototype.format = function() {
    var args = arguments;
    return this.replace(/{(\d+)}/g, function(match, number) { 
      return typeof args[number] != 'undefined'
        ? args[number]
        : match;
    });
  };
}
*/

    if (!String.prototype.format) {
        String.prototype.format = function () {
            var args = arguments;
            return this.replace(/{(\d+)}/g, function (match, number) {
                return typeof args[number] != 'undefined' ? args[number] : match;
            });
        };
    }
